/** @file   animatedobject.cpp
 * @brief   Implementation of AnimatedObject - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "animatedobject.h" // class's header file
#include "gameanims.h"

namespace WeWantWar {


// class constructor
AnimatedObject::AnimatedObject() :
  MobileObject(),
  m_id( GameAnims::ENoAnimation )
{

}

// class destructor
AnimatedObject::~AnimatedObject()
{

}



/** Sets the animation.
 */
void AnimatedObject::setAnimation( const eng2d::Animation& rAnim, int id )
{
  m_animation = rAnim;
  m_id = id;
}



/** Updates the animation.
 */
void AnimatedObject::updateAnim()
{
  m_animation.update();
}



/** Returns the animation id.
 */
int AnimatedObject::getAnimID() const
{
  return m_id;
}



/** Returns the currently visible frame.
 */
int AnimatedObject::getAnimFrame() const
{
  return m_animation.currentFrame().iFrameIndex;
}


} // end of namespace
